﻿using System;
using System.Net;
using System.Web.Security.AntiXss;

namespace VIRP.EFR.BO
{
    [Serializable()]
    public class Study
    {
        public bool IsSensitive { get; set; }
        public int ImageCount { get; set; }

        /// <summary>
        /// Property strings : need to be HTML encoded
        /// </summary>
        public string PatientICN { get; set; }
        public string StudyDate { get; set; }
        public string StudyId { get; set; }
        public string StudyClass { get; set; }
        public string StudyType { get; set; }
        public string StudyDescription { get; set; }
        public string ProcedureDescription { get; set; }
        public string SpecialtyDescription { get; set; }

        /// <summary>
        /// URLs : need to be url encoded
        /// </summary>
        public string ReportUrl { get; set; }
        public string ViewerUrl { get; set; }

        public void EncodeJsonStrings()
        {
            this.PatientICN = AntiXssEncoder.HtmlEncode(this.PatientICN, false);
            this.ProcedureDescription = AntiXssEncoder.HtmlEncode(this.ProcedureDescription, false);
            this.SpecialtyDescription = AntiXssEncoder.HtmlEncode(this.SpecialtyDescription, false);
            this.StudyClass = AntiXssEncoder.HtmlEncode(this.StudyClass, false);
            this.StudyDate = AntiXssEncoder.HtmlEncode(this.StudyDate, false);
            this.StudyDescription = AntiXssEncoder.HtmlEncode(this.StudyDescription, false);
            this.StudyId = AntiXssEncoder.HtmlEncode(this.StudyId, false);
            this.StudyType = AntiXssEncoder.HtmlEncode(this.StudyType, false);

            // The urls come to us encoded already, so we need to decode, then re-encode
            this.ReportUrl = AntiXssEncoder.UrlEncode(WebUtility.UrlDecode(this.ReportUrl));
            this.ViewerUrl = AntiXssEncoder.UrlEncode(WebUtility.UrlDecode(this.ViewerUrl));
        }
    }
}